<?php 

namespace App\Http\Controllers;

use App\Interfaces\TestimonialRepositoryInterface;
use Illuminate\Http\Request;

class TestimonialController extends ApiController {

	/**
	 * @var Testimonial
	 */
	private $testimonial;

	public function __construct(TestimonialRepositoryInterface $testimonial)
	{
		$this->testimonial = $testimonial;
	}

	/**
	 * Get testimonials
	 * 
	 * @return view
	 */
	public function getTestimonials()
	{
		$testimonials = $this->testimonial->getTestimonials();

		return view('cms.testimonials', compact('testimonials'));
	}

	/**
	 * Add testimonial
	 *
	 * @return view
	 */
	public function addTestimonial()
	{
	    return view('cms.add-testimonial');
	}

	/**
	 * Create testimonial
	 *
	 * @return view
	 */
	public function postTestimonial(Request $request)
	{

		$data = [
			'first_name'  => $request->input('first_name'),
			'last_name'   => $request->input('last_name'),
			'testimonial' => $request->input('testimonial'),
			'school'      => $request->input('school'),
			'photoURL'    => $request->file('tutorPhoto')->getClientOriginalName(),
		];

		$fileName = $request->file('tutorPhoto')->getClientOriginalName();
		$destPath = public_path() . '/images/testimonials/';

		if($request->hasFile('tutorPhoto'))
		{
			$image = $request->file('tutorPhoto');

			$image->move($destPath, $fileName);
			
		}

		$testimonial = $this->testimonial->postTestimonial($data);

		if($testimonial)
		{
			return redirect('cms/testimonials');
		}

		return back()->with('message', 'Error creating testimonial.');

	}

	/**
	 * Edit testimonial
	 * 
	 * @return view
	 */
	public function editTestimonial($id)
	{
		$testimonial = $this->testimonial->getTestimonialById($id);

		return view('cms.edit-testimonial', compact('testimonial'));
	}

	/**
	 * Update testimonial
	 * 
	 * @return view
	 */
	public function updateTestimonial(Request $request)
	{
		$testimonialId = $request->input('id');

		$data = [
			'first_name'  => $request->input('first_name'),
			'last_name'   => $request->input('last_name'),
			'testimonial' => $request->input('testimonial'),
			'school'      => $request->input('school'),
			'photoURL'    => $request->file('tutorPhoto')->getClientOriginalName(),
		];

		$fileName = $request->file('tutorPhoto')->getClientOriginalName();
		$destPath = public_path() . '/images/testimonials/';

		if($request->hasFile('tutorPhoto'))
		{
			$image = $request->file('tutorPhoto');

			$image->move($destPath, $fileName);
			
		}

		$testimonial = $this->testimonial->updateTestimonial($testimonialId, $data);

		if($testimonial)
		{
			return redirect('cms/testimonials');
		}

		return back()->with('message', 'Error updating testimonial.');
	}

	/**
	 * Delete testimonial
	 * 
	 * @param  int $id
	 * @return view
	 */
	public function deleteTestimonial($id)
	{
		return view('cms.testimonials');
	}

	public function toggleActiveTestimonial()
	{
	    if(! \Request::ajax()) return false;

		$posted = $_POST['id'];
	    $toggle_active = $this->testimonial->toggleActiveTestimonial($posted);

	    return $toggle_active;
	}
}
