<?php 

namespace App\Http\Controllers;

use App\Interfaces\SchoolRepositoryInterface;
use Illuminate\Http\Request;
use App\SchoolType;

class SchoolController extends ApiController {

	/**
	 * @var SchoolRepositoryInterface
	 */
	private $school;

	public function __construct(SchoolRepositoryInterface $school)
	{
		$this->school = $school;		
	}

	/**
	 * Index
	 * 
	 * @return redirect
	 */
	public function index()
	{
	    return redirect('/cms/schools/primaryK5');
	}

	/**
	 * Primary k5
	 * 
	 * @return view
	 */
	public function primaryK5()
	{
	    $schools = $this->school->getK5schools();

	    return view('cms.schools', compact('schools'));
	}

	/**
	 * Middle 6-8
	 * 
	 * @return view
	 */
	public function middle68()
	{
	    $schools = $this->school->getMiddle68schools();

	    return view('cms.schools', compact('schools'));
	}

	/**
	 * High Schools
	 * 
	 * @return view
	 */
	public function highschool()
	{
	    $schools = $this->school->getHighschools();

	    return view('cms.schools', compact('schools'));
	}

	/**
	 * Get schools
	 * 
	 * @return view
	 */
	public function getSchools()
	{
		$schools = $this->school->getSchools();

		return view('cms.schools', compact('schools'));
	}

	/**
	 * Add school form
	 *
	 * @return view
	 */
	public function addSchool()
	{
		$school_type = SchoolType::lists('name', 'id');

	    return view('cms.add-school', compact('school_type', compact('school_type')));
	}

	/**
	 * Create school
	 * 
	 * @return view
	 */
	public function postSchool(Request $request)
	{
		$data = [
			'name' => $request->input('name'),
			'address' => $request->input('address'),
			'zip_code' => $request->input('zip_code'),
			'county' => $request->input('county'),
			'school_type_id' => $request->input('school_type_id'),
		];

		$school = $this->school->postSchool($data);

		if(!$school)
		{
			return $this->respondInternalError('Error creating school.');
		}

		return redirect('/cms/schools/primaryK5');


	}

	/**
	 * Edit school
	 * 
	 * @return view
	 */
	public function editSchool($id)
	{
		$school = $this->school->editSchool($id);
		$school_type = SchoolType::lists('name', 'id');

		return view('cms.edit-school', compact('school', 'school_type'));
	}

	public function updateSchool(Request $request)
	{
		$data = [
			'name' => $request->input('name'),
			'address' => $request->input('address'),
			'zip_code' => $request->input('zip_code'),
			'county' => $request->input('county'),
			'school_type_id' => $request->input('school_type_id'),
		];
		$schoolId = $request->input('schoolId');

	    $school = $this->school->updateSchool($schoolId, $data);

	    if(!$school)
		{
			return $this->respondInternalError('Error updating school.');
		}

		return redirect('/cms/schools/primaryK5');
	}

	/**
	 * Delete school
	 * 
	 * @return view
	 */
	public function deleteSchool($id)
	{
		$school = $this->school->deleteSchool($id);

		return redirect('/cms/schools/primaryK5');
	}
}