<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Interfaces\ProgramRepositoryInterface;
use App\Program;
use App\Tutor;
use App\School;
use App\Schedule;
use App\Course;
use Carbon\Carbon;

class ProgramController extends ApiController {

	/**
	 * @var ProgramRepositoryInterface
	 */
	private $program;

	public function __construct(ProgramRepositoryInterface $program)
	{
		$this->program = $program;
	}

	public function getPrograms(Request $request)
	{
		if ($request->input('id') == '') 
		{
            $default_course = 4;
        } 
        else 
        {
            $default_course = $request->input('id');
        }
		$programs = $this->program->getPrograms();
		$courses = Course::all();

		return view('cms.programs', compact('courses', 'programs', 'default_course'));
	}

	/**
	 * Get single program
	 * 
	 * @param  Request $request
	 * @return view
	 */
	public function getProgram(Request $request, $id)
	{
		$program = $this->program->getProgram($id);
		// dd($program);
		$courses = Course::all();

		return view('cms.program', compact('courses', 'program'));
	}

	/**
	 * Add program
	 *
	 * @return view
	 */
	public function addProgram()
	{
		$programs = $this->program->getPrograms();
		$tutors = Tutor::all();
		$schools = School::all();
		$courses = Course::all();

	    return view('cms.add-program', compact('courses', 'programs', 'schools', 'tutors'));
	}

	/**
	 * SAT
	 * 
	 * @return view
	 */
	public function sat()
	{
		$data = Program::whereName('SAT')->get();
		return view('programs.SAT', compact('data'));
	}

	/**
	 * SAT Subject Test
	 * 
	 * @return view
	 */
	public function satTest()
	{
		return view('programs.SAT-test');
	}

	/**
	 * ACT
	 * 
	 * @return view
	 */
	public function act()
	{
		return view('programs.ACT');
	}

	/**
	 * PSAT
	 * 
	 * @return view
	 */
	public function psat()
	{
		return view('programs.PSAT');
	}

	/**
	 * SHSAT
	 * 
	 * @return view
	 */
	public function shsat()
	{
		$data = Program::whereName('SHSAT')->get();
		return view('programs.SHSAT', compact('data'));
	}

	/**
	 * SSAT
	 * 
	 * @return view
	 */
	public function ssat()
	{
		$data = Program::whereName('SSAT')->get();
		return view('programs.SSAT', compact('data'));
	}

	/**
	 * ISEE
	 * 
	 * @return view
	 */
	public function isee()
	{
		$data = Program::whereName('ISEE')->get();
		return view('programs.ISEE', compact('data'));
	}

	/**
	 * High School Admissions
	 * 
	 * @return view
	 */
	public function hsa()
	{
		return view('programs.HSA');
	}

	/**
	 * College Admissions
	 * 
	 * @return view
	 */
	public function ca()
	{
		$data = Program::whereName('CA')->get();
		return view('programs.CA', compact('data'));
	}

	/**
	* State Exams
	*
	* @return view
	*/
	public function se()
	{
		$data = Program::whereName('state-exams')->get();
		return view('programs.state-exams', compact('data'));
	}

	/**
	* Writing Workshop
	*
	* @return view
	*/
	public function ww()
	{
		$data = Program::whereName('writing-workshop')->get();
		return view('programs.writing-workshop', compact('data'));
	}

	/**
	* Summer Sessions
	*
	* @return view
	*/
	public function ss()
	{
		$data = Program::whereName('summer-sessions')->get();
		return view('programs.summer-sessions', compact('data'));
	}

	/**
	 * Program Schedule
	 * 
	 * @return mixed
	 */
	public function getProgramSchedule(Request $request)
	{
		if(! \Request::ajax() ) die;

	    $postedId = $request->input('id');
	    
	    $program_data = Program::whereId($postedId)->first();
	    // return $program_data->firstName; exit;
	    $tutor_data = Tutor::whereId($program_data->tutorId)->first();
	    $schedule_data = Schedule::where('programId', $postedId)->get();
	    // dd($schedule_data);
	    $src = \URL::to('/').'/images/users/' . $program_data->photoURL;
	    if($program_data->photoURL=='' or !@getimagesize($src)){$image='no-profile-image.png';} else{$image='users/'.$program_data->photoURL;}
	    
	    if($program_data->price != 0){ $price ='<p>US$ '.$program_data->price.'.00</p>';} else { $price ='<p>Free</p>';}

	    if($program_data->active == 1 && $program_data->price != 0) {
	        $enable_enroll = '<a href="'. \URL::to("/payment?program=") . $program_data->id . '"><div class="button-program enroll-button">Enroll</div></a>';
	    } else if($program_data->active == 1 && $program_data->price == 0) {
	        $enable_enroll = '<a href="'. \URL::to("/enroll?program=") . $program_data->id .'"><div class="button-program enroll-button">Enroll</div></a>';
	    } else {
	    	$enable_enroll = "";
	    }
	    
	    
	    $program_content = '<div class="new_row border-bottom-green" style="height: 5vw;">';   
	    $program_content .= '<div class="column-13">';   
	    $program_content .= '<div class="program-schedule-title">'.$program_data->name.' '.$program_data->type.' Program</div>';
	    $program_content .= '<div class="program-schedule-subtitle">Preparing for '.$program_data->forExam.'</div>';   
	    $program_content .= '</div>';  
	    $program_content .= '<div class="column-3 price-enroll">';
	    $program_content .= '<span>Price:</span><br/>';
	    $program_content .= $price;
	    $program_content .= '</div>';
	    $program_content .= '<div class="column-3 price-enroll">';
	    $program_content .= $enable_enroll;
	    $program_content .= '</div>';
	    $program_content .= '</div>';
	    $program_content .= '<div class="new_row tut-desc border-bottom-green"><div class="column-5">
	                            
	                            <div class="img-tut"><img src="'. \URL::to('/images') . '/' .$image.'"></div>
	            </div>
	            <div class="column-15 tut-desc-box">
	                <div class="tut-name">
	                    <p>'.$program_data->firstName.' '.$program_data->lastName.'</p>
	                    <p>'.$tutor_data->about.'</p>
	                </div>
	            </div>
	            </div>
	            <div class="new_row">';
	            if(count($schedule_data)){
	                $program_content.='<p class="schedule-table-title">Schedule</p>';
	                        
	    $program_content .='</div>
	            <div class="schedule-tables">
	            <table style="width: 100%;">
	                <tr>
	                    <th style="width: 15%;">Date</th>
	                    <th style="width: 15%;">Day</th>
	                    <th style="width: 20%;">Time(EST)</th>
	                    <th style="width: 20%;">Meeting</th>
	                    <th style="width: 30%;">Location</th>
	                </tr>';
	                foreach($schedule_data as $prog) {	
	                $program_content.='<tr>
	                    <td>'.date_format(new \DateTime($prog->date), 'M j').'</td>
	                    <td>'.date_format(new \DateTime($prog->date), 'D').'</td>
	                    <td>'.date_format(new \DateTime($prog->time_start),'g:i a').'-'.date_format(new \DateTime($prog->time_end),'g:i a').'</td>
	                    <td>'.$prog->meeting.'</td>
	                    <td>'.$prog->location.'</td>
	                </tr>';
	                }
	                $program_content.='</table>
	                           
	            </div>
	        </div>';
	    		} else {
	                $program_content.='<p class="schedule-table-title">No schedule yet.</p></div>';
	            }

    	// $program_content = json_encode($program_content);

	    return json_encode($program_content);
	}

	/**
	 * @return ajax post
	 */
	public function toggleEnrollment()
	{
		if(! \Request::ajax()) return false;

		$posted = $_POST['id'];
	    //$toggle_active = ORM::factory('Cms_Programs_Program')->where('ID_programs','=',$posted)->find();
	    $toggle_active = Program::find($posted);
	    
	    if($toggle_active->active){
	      $toggle_active->active = 0;
	      $return = 0;
	    } else {
	      $toggle_active->active = 1;
	      $return = 1;
	    }
	    
	    $toggle_active->save();
	    
	    return $return;

	}



}