<?php 

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Notes;
use Auth;

class NotesController extends ApiController {

	public function getNotes()
	{

		return view('ivykey.notes');
	}

	public function getNewNote()
	{
		return view('ivykey.newNote');
	}

	public function addNote(Request $request)
	{
		if(!$request->ajax()) 
		{
			return false;
		}

        $title = strip_tags($_POST['title']);
        $body = strip_tags($_POST['body']);
        $color = $_POST['color'];
        $zindex = (int)$_POST['zindex'];

        $note = new Notes;
        $note->user_id = Auth::user()->id;
        $note->text = $body;
        $note->title = $title;
        $note->color = $color;
        $note->xyz = "0x0x" . $zindex;
        $note->dt = new \DateTime();

        $note->save();

        return $note;
	}

	/**
	 * Move note
	 * 
	 * @param  Request $request
	 * @return mixed
	 */
	public function moveNote(Request $request)
	{
		if(! $request->ajax())
		{
			return false;
		} 
			

        if(!is_numeric($_POST['id']) || !is_numeric($_POST['x']) || !is_numeric($_POST['y']) || !is_numeric($_POST['z'])) die("0");

        $id = (int)$_POST['id'];
        $x = (int)$_POST['x'];
        $y = (int)$_POST['y'];
        $z = (int)$_POST['z'];

        $note = Notes::find($id);
        $note->xyz = $x."x".$y."x".$z;
        echo $note->save();

	}

	/**
	 * Delete note
	 * 
	 * @param  int $id
	 * @return mixed
	 */
	public function deleteNote(Request $request)
	{	
		if(! $request->ajax())
		{
			return false;
		} 

		$id = (int)$_POST['id'];
		$note = Notes::find($id);
		$note->delete();

	}


}