<?php 

namespace App\Http\Controllers;

use App\Interfaces\NewsRepositoryInterface;

class NewsController extends ApiController {

	/**
	 * @var NewsRepositoryInterface
	 */
	private $news;

	public function __construct(NewsRepositoryInterface $news)
	{
		$this->news = $news;
	}

	/**
	 * Get news
	 * 
	 * @return view
	 */
	public function getNews()
	{
		$news = $this->news->getNews();

		return view('cms.news', compact('news'));
	}

	/**
	 * Add news
	 * 
	 * @return view
	 */
	public function addNews()
	{
		return view('cms.add-news', compact('news'));
	}

		/**
	 * Create news
	 * 
	 * @return view
	 */
	public function postNews()
	{
		return view('cms.news');
	}

		/**
	 * Edit news
	 *
	 * @param  int $id
	 * @return view
	 */
	public function editNews($id)
	{
		return view('cms.news');
	}

		/**
	 * Get news
	 *
	 * @param int $id
	 * @return view
	 */
	public function deleteNews($id)
	{
		return view('cms.news');
	}
}