<?php 

namespace App\Http\Controllers;

use Auth;
use App\Message;

class MessagesController extends ApiController {

	/**
	 * @return view
	 */
	public function index()
	{
		return redirect('/ivykey/dashboard/messages/inbox');
	}

	/**
	 * Inbox
	 * 
	 * @return view
	 */
	public function inbox()
	{
		$box = 'inbox';
		$messages = Message::where('receiver_id', '==', Auth::user()->id);
		$pagination = $messages->paginate(15);
		$numberInbox = Message::where('receiver_id', '==', Auth::user()->id)->count();
		$numberHomework = Message::where('receiver_id', '==', Auth::user()->id)->count();

		return view('ivykey.messages', compact('box', 'messages', 'pagination', 'numberInbox', 'numberHomework'));
	}

	/**
	 * Outbox
	 * 
	 * @return view
	 */
	public function outbox()
	{
		$box = 'outbox';
		$messages = Message::where('receiver_id', '==', Auth::user()->id);
		$pagination = $messages->paginate(15);
		$numberInbox = Message::where('receiver_id', '==', Auth::user()->id)->count();
		$numberHomework = Message::where('receiver_id', '==', Auth::user()->id)->count();

		return view('ivykey.messages', compact('box', 'messages', 'pagination', 'numberInbox', 'numberHomework'));
	}

	/**
	 * Homework
	 * 
	 * @return view
	 */
	public function homework()
	{
		$box = 'homework';
		
		return view('ivykey.messages', compact('box'));
	}


}