<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use App\Tutor;
use App\Testimonial;
use App\News;
use App\User;
use App\School;
use App\Course;
use App\Grade;
use Validator;
use Auth;


class HomeController extends ApiController {

	/**
	 * Index
	 * @return mixed
	 */
	public function index()
	{
		if(Auth::check())
		{
			//admin/moderator
			if(Auth::user()->role == 'admin' || Auth::user()->role == 'moderator')
			{
				return redirect('/cms');
			}

			//tutor
			if(Auth::user()->role == 'tutor')
			{
				return redirect('/admin/administration');
			}

			//student
			if(Auth::user()->role == 'student')
			{
				return redirect('/ivykey/dashboard');
			}
		}

		$testimonials = Testimonial::whereActive('1')->get();
		$rnd1 = rand(0, (count($testimonials) - 1) );
        do 
        {
            $rnd2 = rand(0, (count($testimonials)-1));
        } 
        while ($rnd1 == $rnd2);

        $testims = array ($testimonials[$rnd1], $testimonials[$rnd2]);

		return view('index', compact('testims'));
	}

	/**
	 * Login form
	 * 
	 * @return view
	 */
	public function getLogin()
	{
		if( Auth::check())
		{
			return redirect('ivykey/dashboard');
		}

		return view('login');
	}

	/**
	 * Login user
	 * 
	 * @return mixed
	 */
	public function postLogin(Request $request)
	{

		// dd($request->all());
		$validator = Validator::make($request->all(), [
			'username'  => 'required',
			'password'  => 'required|min:6'
		]);

		if($validator->fails())
		{
			return redirect('/fail')
				->withErrors($validator)
				->withInput();
		}
		else
		{	
			if(Auth::attempt([
				'username' => $request->input('username'),
				'password' => $request->input('password')
			]))
			{
				//check if admin or moderator
				if(Auth::user()->username === 'admin' || Auth::user()->username === 'moderator')
				{
					return redirect('/cms');
				}
				return redirect('/');
			}
			else
			{
				return redirect()->back()->with('status', 'Incorrect username or password.');
			}	
		}		
	}

	/**
	 * Get register
	 * 
	 * @return mixed
	 */
	public function getRegister()
	{
		$programs = Course::lists('name', 'id');
		$grades = Grade::lists('name', 'id');
		$schools = School::lists('name', 'id');

		return view('register', compact('programs', 'grades', 'schools'));
	}

	/**
	 * Post register
	 * 
	 * @return mixed
	 */
	public function postRegister()
	{
		
	}

	/**
	 * Tutors
	 * 
	 * @return mixed
	 */
	public function tutors()
	{
		$tutors = Tutor::whereActive('1')->get();

		return view('tutors', compact('tutors'));
	}

	/**
	 * Services
	 * 
	 * @return mixed
	 */
	public function services()
	{
		$testimonials = Testimonial::whereActive('1')->get();
		$rnd1 = rand(0, (count($testimonials) - 1));
        do 
        {
            $rnd2 = rand(0, (count($testimonials)-1));
        } 
        while ($rnd1 == $rnd2);

        $testims = array ($testimonials[$rnd1], $testimonials[$rnd2]);

		return view('services', compact('testims'));
	}

	/**
	 * Products
	 * 
	 * @return mixed
	 */
	public function products()
	{
		return view('products');
	}

	/**
	 * Testimonials
	 * 
	 * @return mixed
	 */
	public function testimonials()
	{
		$testimonials = Testimonial::all();
		return view('testimonials', compact('testimonials'));
	}

	/**
	 * Programs
	 * 
	 * @return mixed
	 */
	public function programs()
	{
		return view('programs');
	}

	/**
	 * About us
	 * 
	 * @return mixed
	 */
	public function aboutus()
	{
		$news = News::orderBy('created_at', 'desc')->limit(2)->get();
		
		return view('aboutus', compact('news'));
	}

	/**
	 * Search
	 * 
	 * @return mixed
	 */
	public function search()
	{
		return view('partials.search');
	}

	/**
	 * Send mail
	 * 
	 * @return mixed
	 */
	public function sendmail()
	{
		
	}

	public function profile($id)
	{
		$tutor = Tutor::whereId($id)->get();
		return view('profile', compact('tutor'));
	}

	/**
	 * List of schools
	 * 
	 * @return mixed
	 */
	public function schoolChange()
	{
	    if(! Request::ajax()) return false;

	    

	}

}