<?php 

namespace App\Http\Controllers;

use App\Group;
use App\Tutor;
use App\School;
use App\Course;
use App\User;
use Illuminate\Http\Request;

class GroupController extends ApiController {

    /**
     * View all groups
     * 
     * @return view
     */
    public function index()
    {
        $groups = Group::with(['tutors', 'courses', 'schools'])->get();
        // return $groups; exit;

        return view('admin.groups', compact('groups'));
    }

    /**
     * Get single group
     * 
     * @return view
     */
    public function getGroup($id)
    {
        $group = Group::whereId($id)->with(['tutors', 'courses', 'schools', 'users'])->get();
        // return $group; exit;
        return view('admin.show-group', compact('group'));
    }

    /**
     * Add group
     *
     * @return  view
     */
    public function addGroup()
    {
        $tutors = Tutor::all();
        $schools = School::orderBy('name')->get();
        $courses = Course::all();

        return view('admin.add-group', compact('tutors', 'schools', 'courses'));
    }

    /**
     * Create group
     * 
     * @return view
     */
    public function createGroup(Request $request)
    {
        $data = [
            'name' => $request->input('name'),
            'begin_date' => $request->input('begin_date'),
            'end_date' => $request->input('end_date'),
            'tutor_id' => $request->input('tutor_id'),
            'course_id' => $request->input('course_id'),
            'school_id' => $request->input('school_id'),
        ];

        $group = new Group();
        
        if(isset($data['name']))
        {
            $group->name = $data['name'];
        }

        if(isset($data['begin_date']))
        {
            $group->begin_date = $data['begin_date'];
        }

        if(isset($data['end_date']))
        {
            $group->end_date = $data['end_date'];
        }

        if(isset($data['tutor_id']))
        {
            $group->tutor_id = $data['tutor_id'];
        }

        if(isset($data['course_id']))
        {
            $group->course_id = $data['course_id'];
        }

        if(isset($data['school_id']))
        {
            $group->school_id = $data['school_id'];
        }

        $group->save();

        if($group)
        {
            return redirect('/admin/administration/manage-groups');
        }

    }

    /**
     * Edit group
     *
     * @param  int $id
     * @return view
     */
    public function editGroup($id)
    {
        $group = Group::find($id);
        $tutors = Tutor::all();
        $schools = School::orderBy('name')->get();
        $courses = Course::all();

        return view('admin.edit-group', compact('group', 'tutors', 'schools', 'courses'));
    }

    /**
     * Delete group
     * 
     * @return view
     */
    public function deleteGroup($id)
    {
        $group = Group::find($id);

        if($group->delete())
        {
            return back()->with('delinfo', 'Group deleted.');
        }
    }

    /**
     * Remove student from group
     * 
     * @return redirect back
     */
    public function removeStudent(Request $request)
    {
        $userId = $request->input('userId');
        $groupId = $request->input('groupId');
        $user = User::find($userId);

        $user->groups()->detach($groupId);

        return back()->with('delinfo', 'Student removed.');
    }

    /**
     * Add Student via Ajax
     */
    public function addStudent(Request $request)
    {
        if(! $request->ajax()) return false;

        $group = Group::find($request->input('groupId'));
        $schools = School::orderBy('name')->get();

        return view('admin.ajax.addStudent', compact('schools', 'group'));
    }

    /**
     * Get students by school
     * 
     * @return mixed
     */
    public function getStudents(Request $request)
    {
        if(! $request->ajax()) return false;

        $schoolId = $request->input('schoolId');
        
        // find students by school id 
        $students = User::where('school_id', $schoolId)->get();

        return $students;

    }

}