<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Auth;
use App\Grade;
use App\School;
use App\Course;
use App\Group;
use App\Notes;

class DashboardController extends Controller
{

    /**
     * Constructor
     */
    public function __construct()
    {
       $this->middleware('auth'); 
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $programs = Course::lists('name', 'id');
        $grades = Grade::lists('name', 'id');
        $schools = School::lists('name', 'id');

        return view('ivykey.dashboard', compact('programs', 'grades', 'schools'));
    }

    /**
     * Classroom
     * 
     * @return view
     */
    public function classroom()
    {
        $user = Auth::user();
        $class = $user->programs()->get();
        $groups = $user->groups()->get();

        return view('ivykey.classroom', compact('class', 'groups'));

    }

    /**
     * Calendar
     * 
     * @return view
     */
    public function calendar()
    {   
        $user = Auth::user();
        $groups = $user->groups()->get();
        $group_id = $groups[0]->id;

        return view('ivykey.calendar', compact('groups', 'group_id'));
    }

    /**
     * Notes
     * 
     * @return view
     */
    public function notes()
    {
        $user = Auth::user();
        $allNotes = $user->notes()->get();
        
        return view('ivykey.notes', compact('user', 'allNotes'));
    }

    /**
     * Support
     * 
     * @return view
     */
    public function support()
    {
        return view('ivykey.support');
    }

    /**
     * Logout user
     * 
     * @return mixed
     */
    public function getLogout()
    {
        Auth::logout();

        return redirect('/');
    }

}
