<?php 

namespace App\Http\Controllers;

use App\Course;
use Illuminate\Http\Request;

class CourseController extends ApiController {

		/**
	 * Manage Courses
	 * 
	 * @return view
	 */
	public function manageCourses()
	{
		$courses = Course::all();
		return view('admin.courses', compact('courses'));
	}

	/**
	 * Add Course
	 *
	 * @return  view
	 */
	public function addCourse()
	{
		return view('admin.add-course');
	}

	/**
	 * Create course
	 * 
	 * @return mixed
	 */
	public function createCourse(Request $request)
	{
		$data = [
			'name' => $request->input('name')
		];

		if(isset($data['name']))
		{
			$course = new Course();
			$course->name = $request->input('name');
			$course->active = 1;
			$course->save();

			return redirect('/admin/administration/manage-courses');
		}

		return back()->with('errors', 'Error creating course.');
	}

	public function showCourse($id)
	{
		$course = Course::find($id);

		return view('admin.show-course', compact('course'));
	}

	/**
	 * Delete course
	 * 
	 * @param  int $id
	 * @return redirect
	 */
	public function deleteCourse($id)
	{
		$course = Course::find($id);

		if($course->delete())
		{
			return redirect('/admin/administration/manage-courses')->with('delinfo', 'Course deleted.');
		}
	}

}