<?php

namespace App\Http\Controllers;

use Auth;
use App\Group;
use App\Classroom;
use Illuminate\Http\Request;

class ClassroomController extends ApiController {

    private $classroom;
    private $userID;
    private $groupName;
    private $ProfPWD;
    private $StudPWD;

    public function __construct(Classroom $classroom, Request $request)
    {
        $this->classroom = $classroom;
        $this->groupName = $request->input('groupName');
        $this->profesor = Auth::user()->first_name.'+'.Auth::user()->last_name;
    }

    /**
     * Manage Classroom
     * 
     * @return view
     */
    public function index()
    {
        // get group by tutor 
        $tutorId = Auth::user()->id;
        $groups = Group::where('tutor_id', $tutorId)->get();
        // return $groups; exit;
        return view('admin.classroom', compact('groups'));
    }

    /**
     * Create Classroom
     * 
     * @return view
     */
    public function createClassroom(){

        if(!Auth::user()->role == 'tutor')
        {
            return false;
        }

        $this->ProfPWD = $this->generateRandomString();
        $this->StudPWD = $this->generateRandomString();
        $name = str_replace(" ", "+", $this->groupName);
        $meetingID = $this->generateRandomString();

        $chksum = $this->calculate_SHA1('createname='.$name.'&meetingID='.$meetingID.'&attendeePW='.$this->StudPWD.'&moderatorPW='.$this->ProfPWD.'&logoutURL=http://theivykey.com');

        $respondBBB = file_get_contents(\Config::get('bbb.CONFIG_SERVER_BASE_URL').'api/create?name='.$name.'&meetingID='.$meetingID.'&attendeePW='.$this->StudPWD.'&moderatorPW='.$this->ProfPWD.'&logoutURL=http://theivykey.com'.'&checksum='.$chksum);

        if (strpos($respondBBB,'SUCCESS') == false) 
        {
            echo 'Classroom is not created!'; die();
        }

        $classrooms = $this->classroom->where('group_name', $this->groupName)->get();

        foreach($classrooms as $class)
        {
            if($class->group_name == $this->groupName)
            {
                $class->meeting_id = $meetingID;
                $class->professor_pw = $this->ProfPWD;
                $class->student_pw = $this->StudPWD;
                $class->save();
            }
            else
            {
                $this->classroom->group_name = $this->groupName;
                $this->classroom->meeting_id = $meetingID;
                $this->classroom->professor_pw = $this->ProfPWD;
                $this->classroom->student_pw = $this->StudPWD;
                $this->classroom->save();
            }
        }

        $chksum = $this->calculate_SHA1('joinmeetingID='.$meetingID.'&password='.$this->ProfPWD.'&fullName='.$this->profesor);
        $link = \Config::get('bbb.CONFIG_SERVER_BASE_URL') . 'api/join?meetingID='.$meetingID.'&password='.$this->ProfPWD.'&fullName='.$this->profesor.'&checksum='.$chksum;

        return view('admin/classroom-join', compact('link'));

    }

    /**
     * Check Classroom Status
     * 
     * @param  Request $request
     * @return mixed
     */
	public function checkClassroomStatus(Request $request)
	{
		if(!$request->ajax()) {return FALSE; die();}

        $usr = Auth::user()->id;
        $usrQuery = $request->input('user');

        if($usr == $usrQuery){
            $respond = array();
            $groups = $this->classroom->getStudentGroups($usr);

            foreach ($groups as $group) 
            {
                $groupId = $this->classroom->where('group_name', $group->name)->first();
                // return $groupId; exit;
                if(!$groupId)
                {
                    $grp_status = 0;
                } 
                else 
                {
                    $grp_status = $this->isClassroomRunning($groupId->meeting_id);
                }

                $respond[$group->name] = $grp_status;
            }
            echo json_encode($respond);
        } 
        else 
        {
            echo json_encode('False user id!.');
        }
	}

    /**
     * Join Classroom
     * 
     * @param  Request $request
     * @return view
     */
    public function joinClassroom(Request $request)
    {

        if( !Auth::user()->role == 'student' ) die();
        $grp = $request->input('group');

        $joinId = $this->classroom->where('group_name', $grp)->first();
        // return $joinId->meeting_id; exit;
        $meetId = $joinId->meeting_id;
        $meetPw = $joinId->student_pw;

        $chksum = $this->calculate_SHA1('joinmeetingID='.$meetId.'&password='.$meetPw.'&fullName='.$this->profesor.'&logoutURL=http://theivykey.com/ivykeyportal');
        $link = \Config::get('bbb.CONFIG_SERVER_BASE_URL') . 'api/join?meetingID='.$meetId.'&password='.$meetPw.'&fullName='.$this->profesor.'&logoutURL=http://theivykey.com/ivykeyportal'.'&checksum='.$chksum;

        return view('admin/classroom-join', compact('link'));
    }

    /**
     * Calculate sha1 string
     * 
     * @param  string $string
     * @return string
     */
    protected function calculate_SHA1($string) 
    {
        return sha1($string . \Config::get('bbb.CONFIG_SECURITY_SALT'));
    }

    /**
     * Check if classroom is running
     * 
     * @param  int  $groupId
     * @return boolean
     */
    protected function isClassroomRunning($groupId)
    {

        $chksum = $this->calculate_SHA1('isMeetingRunningmeetingID='.$groupId);
        $respondBBB = file_get_contents(\Config::get('bbb.CONFIG_SERVER_BASE_URL').'api/isMeetingRunning?meetingID='.$groupId.'&checksum='.$chksum);

        $resp = new \SimpleXMLElement($respondBBB);

        return ($resp->running[0]=='true') ? 1 : 0;
    }

    /**
     * Generate random string
     * 
     * @param  integer $length
     * @return string
     */
    protected function generateRandomString($length = 10) 
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}