<?php 

namespace App\Http\Controllers;

use Auth;
use App\Tutor;
use App\User;
use App\School;

class CMSController extends ApiController {

    public function index()
    {
        $tutors = Tutor::all();
        $activeTutors = Tutor::whereActive('1')->get();
        $students = User::all();
        $activeStudents = User::whereActive('1')->get();
        $schools = School::all();
        $schoolK5 = School::where('school_type_id', 1)->get();
        $schoolMid = School::where('school_type_id', 2)->get();
        $schoolHi = School::where('school_type_id', 3)->get();

        return view('cms.index', compact('tutors', 'students', 'activeTutors', 'activeStudents', 'schools', 'schoolK5', 'schoolMid', 'schoolHi'));
    }

    /**
     * Logout user
     * 
     * @return view
     */
    public function getLogout()
    {
        Auth::logout();

        return redirect('/');
    }

}