<?php 

namespace App\Http\Controllers;

use Auth;
use Excel;
use App\Message;
use App\User;
use App\School;
use App\Group;
use App\Program;
use Illuminate\Http\Request;

class AdministrationController extends ApiController {

	/**
	 * Index
	 * 
	 * @return view
	 */
	public function index()
	{
		return view('admin.home');
	}

	/**
	 * Manage Users
	 * 
	 * @return view
	 */
	public function manageUsers()
	{
		$users = User::all();
		$schools = School::all();

		return view('admin.users', compact('users', 'schools'));
	}

	/**
	 * Manage Students
	 * 
	 * @return view
	 */
	public function manageStudents()
	{
		$baseUrl = url('/');
		$schools = School::all();
		$students = User::where('role', 'student')->with('programs')->paginate(10);
		$students->setPath($baseUrl . '/admin/administration/manage-students');
		// $students = User::where('role', 'student')->with('programs')->get();

		// return $students; exit;
		return view('admin.students', compact('schools', 'students'));
	}

	/**
	 * Export to excel
	 * 
	 * @return mixed
	 */
	public function toExcel()
	{

		$students = User::where('role', 'student')->with('programs')->get();

		Excel::create('Students', function($excel) use ($students)
		{
			$excel->sheet('New sheet', function($sheet) use ($students)
			{
				$sheet->loadView('admin.excel-students')->with('students', $students);
			});

			$excel->export('xls');
		});
	}

	/**
	 * Add student
	 *
	 * @return  view
	 */
	public function addStudent()
	{
		$programs = Program::where('active', 1)->get();
		//dd($programs);
		return view('admin.add-student', compact('programs'));
	}

	/**
	 * Edit student
	 * 
	 * @param  int $id
	 * @return view
	 */
	public function editStudent($id)
	{
		$student = User::find($id);
		$programs = Program::where('active', 1)->get();

		return view('admin.edit-student', compact('student', 'programs'));
	}

	/**
	 * Create new student
	 * 
	 * @return redirect
	 */
	public function createStudent(Request $request)
	{
		$data = [
			'first_name' => $request->input('first_name'),
			'last_name' => $request->input('last_name'),
			'email' => $request->input('email'),
			'parent_email' => $request->input('parent_email'),
			'home_phone' => $request->input('home_phone'),
			'class_id' => $request->input('class_id')
		];

		$user = new User();
		if(isset($data['first_name']))
		{
			$user->first_name = $data['first_name'];
		}

		if(isset($data['last_name']))
		{
			$user->last_name = $data['last_name'];
		}

		if(isset($data['email']))
		{
			$user->email = $data['email'];
		}

		if(isset($data['parent_email']))
		{
			$user->parent_email = $data['parent_email'];
		}

		if(isset($data['home_phone']))
		{
			$user->home_phone = $data['home_phone'];
		}

		$user->role = 'student';
		$user->save();

		if(isset($data['class_id']))
		{
			$user->programs()->attach($data['class_id']);
		}

		return redirect('/admin/administration/manage-students');
	}

	/**
	 * Update student
	 * 
	 * @return redirect
	 */
	public function updateStudent(Request $request)
	{
		$user = User::find($request->input('student_id'));

		$data = [
			'first_name' => $request->input('first_name'),
			'last_name' => $request->input('last_name'),
			'email' => $request->input('email'),
			'parent_email' => $request->input('parent_email'),
			'home_phone' => $request->input('home_phone'),
			'class_id' => $request->input('class_id')
		];

		if(isset($data['first_name']))
		{
			$user->first_name = $data['first_name'];
		}

		if(isset($data['last_name']))
		{
			$user->last_name = $data['last_name'];
		}

		if(isset($data['email']))
		{
			$user->email = $data['email'];
		}

		if(isset($data['parent_email']))
		{
			$user->parent_email = $data['parent_email'];
		}

		if(isset($data['home_phone']))
		{
			$user->home_phone = $data['home_phone'];
		}

		$user->role = 'student';
		$user->save();

		if(isset($data['class_id']))
		{
			//check if user with that data exists
			if(! $user->programs->contains($data['class_id']))
			{
				$user->programs()->attach($data['class_id']);
			}
			
		}

		return redirect('/admin/administration/manage-students');
	}

	/**
	 * Delete student
	 * 
	 * @param  int $id
	 * @return redirect
	 */
	public function deleteStudent($id)
	{
		$student = User::find($id);

		if($student->delete())
		{
			return back()->with('delinfo', 'Student deleted.');
		}
	}

	/**
	 * Remove assigned class
	 * 
	 * @param  int $id
	 * @return mixed
	 */
	public function removeClass(Request $request)
	{
		if(! $request->ajax()) return false;

		$programId = $request->input('programId');
		$studentId = $request->input('studentId');
		$user = User::find($studentId);

		$user->programs()->detach($programId);

		return back();
	}

	/**
	 * Manage Courses
	 * 
	 * @return view
	 */
	public function manageCourses()
	{
		return view('admin.courses');
	}

	/**
	 * Admin logout
	 * 
	 * @return redirect
	 */
	public function logout()
	{
		Auth::logout();
		return redirect('/');
	}

	/**
	 * Check Messages
	 * 
	 * @return mixed
	 */
	public function checkMessages()
	{
	    if(! Auth::check()) return redirect()->back();

		//$mess = ORM::factory('Front_Message');
		$mess = Message::where('receiver_id', Auth::user()->id)->where('seen', 0)->get();
		
		// $pagination = Pagination::factory(array(
		// 'total_items' => $mess->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)->and_where('type', '=', '0')->count_all(),
		// 'items_per_page' => 10,
		// )
		// );
		// $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
		// $messages = $mess->offset($pagination->offset)
		// ->limit($pagination->items_per_page)
		// ->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)
		// ->and_where('type', '=', '0')
		// ->and_where('seen', '=', '0')
		// ->and_where('erased_by_receiver', '=', NULL)
		// ->find_all(); 


		echo count($mess);
	}

}