<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    public function tutors()
    {
    	return $this->belongsTo('App\User', 'tutor_id');
    }

    public function courses()
    {
    	return $this->belongsTo('App\Course', 'course_id');
    }

    public function schools()
    {
    	return $this->belongsTo('App\School', 'school_id');
    }

    public function users()
    {
        return $this->belongsToMany('App\User', 'group_user');
    }
}
