<?php defined('SYSPATH') or die('No direct script access.');



class Model_Front_Message extends ORM {


        protected $_db_group = 'alternate';
        protected $_table_name = 'view_messages';
        protected $_primary_key = 'ID_message';
        protected $_table_columns = array(

                'ID_message' => NULL,

                'ID_sender' => NULL,

                'ID_receiver' => NULL,

                'title' => NULL,

                'content' => NULL,

                'attachmentURL' => NULL,

                'type' => NULL,

                'priority' => NULL,

                'seen' => NULL,

                'erased_by_sender' => NULL,

                'erased_by_receiver' => NULL,

                'user_group' => NULL,

                'user_program' => NULL,

                'send_date' => NULL,

                'sender_username' => NULL,

                'sender_firstname' => NULL,

                'sender_lastname' => NULL,

                'sender_photoURL' => NULL,

                'sender_email' => NULL,

                'sender_type' => NULL

        );

        

        

        public function getPagine($page){

            $results_per_page = 10;

            return $this->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)->offset($results_per_page*$page)->limit($results_per_page)->find_all();

        }

        

        public function seenMessage($idMess){

            $message = $this->where('ID_message', '=', $idMess)->find();

            $message->seen = 1;

            return $message->update();

        }


       public function deleteMessage($idMess,$action) {

           $message = $this->where('ID_message', '=', $idMess)->find();

           if ( $action == 'Inbox' || $action == 'inbox') {
     
           $message->erased_by_receiver = 1;

           }

           if ($action == 'Sent' || $action == 'outbox') {
           
           $message->erased_by_sender = 1;

           }
        
        return $message->update();

       }

       public function saveMessage($post, $filename){
          
          $this->ID_sender = Auth::instance()->get_user()->ID_user;
          $this->ID_receiver = $post['to'];
          $this->title = htmlentities($post['subject']);
          $this->content = nl2br(htmlentities($post['content']));
          $this->attachmentURL = $filename;
          $this->save();
       }




}