<?php


class Controller_Messages extends Controller_Generic {

     public function __construct(Request $request, Response $response){

     parent::__construct($request,$response);

    $user = Auth::instance()->get_user();

     if(!empty($user)) {

       if ( Auth::instance()->logged_in(array('tutor')) ){
         session_start();
         $_SESSION['user_type'] = 'tutor';
       }

       elseif ( Auth::instance()->logged_in(array('student'))) {
         header('Location: http://www.theivykey.com/');
         exit;

       }

       elseif ( Auth::instance()->logged_in(array('admin'))) {
         session_start();
         $_SESSION['user_type'] = 'admin';
        

       }

       else {
        echo 'this user is not tutor';
       }
   } else {
       header('Location: http://www.theivykey.com/');
       exit;
   }


   }




    public function action_Inbox(){
      
        
        if(!Auth::instance()->get_user())  $this->redirect('../');
        
        $mess = ORM::factory('Front_Message');
        $users = ORM::factory('AuthUser');
        $limit = 10;
    
        $messages = $mess->offset($pagination->offset)
                        ->limit($limit)
                        ->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)
                        ->and_where('type', '=', '0')
                        ->and_where('erased_by_receiver', '=', NULL)
                        ->order_by('send_date', 'desc')
                        ->find_all(); 
  
       
        if ($_GET['ajax_load'] == 1) {

     

          if( !empty($messages) ) {
          foreach ($messages as $message) {
         ?>

                         <thead>
                           <input type='hidden' id='current_page_action' value='inbox'>
                              <tr>
                                  <th style='width:17px'><input type="checkbox" name="checkRow" class="check_all_rem"></th>
                                  <th style='width:50px'>Priority</th>
                                  <th>Sender</th>
                                  <th>Subject</th>
                                  <th></th>
                                  <th>Date</th>
                              </tr>
                          </thead>
                          <tbody>
                        <?php   foreach ($messages as $message):
                    $message_sender = $users->where('ID_user','=',$message->ID_receiver)->find_all();
                    $sender = $message_sender[0]->first_name . ' ' . $message_sender[0]->last_name;
                    ?>
                    <tr>
                        <input type="hidden" name="id" value="<?php echo $message->ID_message;?>"/>
                        <input type="hidden" name="id_sender" value="<?php echo $message->ID_sender;?>"/>
                        <input type="hidden" class="content" value='<?php echo html_entity_decode($message->content);?>'/>
                        <input type="hidden" class="attach" value="<?php echo $message->attachmentURL;?>"/>
                        <td class="check"><input class="ckd" name ='rem_check' value="<?php echo $message->ID_message?>" type="checkbox"/></td>
                        <td class="priority"><div class="<?php echo $message->priority ? 'uk-icon-star' : 'uk-icon-star-o';?> star_priority"></div></td>
                        <?php if($box=='outbox'){ ?>
                            <td class="shMessage from" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $sender?></td>
                        <?php } else { ?>
                            <td class="shMessage from" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $message->sender_firstname.' '.$message->sender_lastname?></td>
                        <?php }?>
                        <td class="shMessage subject" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $message->title;?></td>
                        <td class="shMessage attachment" <?php echo ($message->seen)?'style="color:#a5a5a5;"':'style="color:black;"'?>><div class="<?php echo $message->attachmentURL !='' ? 'uk-icon-paperclip' : '';?>"></div></td>
                        <td class="shMessage date" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo DateTime::createFromFormat('Y-m-d H:i:s', $message->send_date)->format('d/m/Y - H:i');?></td>
                    </tr>
                    <?php endforeach;?>
                          </tbody>

       <?php
       }
       }

       else {
         ?>
           
           <p> No Messages</p>

         <?php

       }
       //stop execution for ajax call
          die();

       }

    else {

         $group_model = Model::factory('study');
         $get_students = $group_model->get_tutor_students(Auth::instance()->get_user()->ID_user);


        $this->template->title = 'Inbox - Messages - The Ivy Key Portal';
        $this->template->content = View::factory('pannonia/Messages_view')
        ->set('users',$users)
        ->set('messages',$messages)
        ->set('students', $get_students);

        }


        /*  
        $this->template->header->page = 'Messages';
        $this->template->content = View::factory('front/messages', array('users' => $users, 'pagination' => $pagination));
        $this->template->content->messages = $messages;
        $this->template->content->box = 'inbox';
        $this->template->content->numberInbox = $this->checkInboxContent();
        $this->template->content->numberHomework = $this->checkHomeworkContent();
       */
        
      }


    public function action_Sent(){




        if(!Auth::instance()->get_user())  $this->redirect('../');


        
        $mess = ORM::factory('Front_Message');
        $users = ORM::factory('AuthUser');
        $pagination = Pagination::factory(array(
         'total_items' => $mess->where('ID_sender','=',Auth::instance()->get_user()->ID_user)->count_all(),
         'items_per_page' => 10,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        ///if($activeStudent) {
        $messages = $mess->offset($pagination->offset)
        ->limit($pagination->items_per_page)
        ->where('ID_sender','=',Auth::instance()->get_user()->ID_user)
        ->and_where('erased_by_sender', '=', NULL)
        ->order_by('send_date', 'desc')
        ->find_all();
      //  } else  {$messages = array();}

 if ($_GET['ajax_load'] == 1) {


    if ( $messages ) {
       foreach ($messages as $message) {
         ?>
                      <thead>
                      <input type='hidden' id='current_page_action' value='outbox'>
                              <tr>
                                  <th style='width:17px'><input type="checkbox" name="checkRow " class="check_all_rem"></th>
                                  <th style='width:50px' class='priority_column'>Priority</th>
                                  <th class='sender_column'>Sender</th>
                                  <th class='subject_column'>Subject</th>
                                  <th></th>
                                  <th class='date_column'>Date</th>
                              </tr>
                          </thead>
                          <tbody>
                        <?php   foreach ($messages as $message):
                    $message_sender = $users->where('ID_user','=',$message->ID_receiver)->find_all();
                    $sender = $message_sender[0]->first_name . ' ' . $message_sender[0]->last_name;
                    ?>
                    <tr>
                        <input type="hidden" name="id" value="<?php echo $message->ID_message;?>"/>
                        <input type="hidden" name="id_sender" value="<?php echo $message->ID_sender;?>"/>
                        <input type="hidden" class="content" value='<?php echo html_entity_decode($message->content);?>'/>
                        <input type="hidden" class="attach" value="<?php echo $message->attachmentURL;?>"/>
                        <td class="check"><input class="ckd" name='rem_check' value="<?php echo $message->ID_message?>" type="checkbox"/></td>
                        <td class="priority"><div class="<?php echo $message->priority ? 'uk-icon-star' : 'uk-icon-star-o';?> star_priority"></div></td>
                        <?php if($box=='outbox'){ ?>
                            <td class="shMessage from" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $sender?></td>
                        <?php } else { ?>
                            <td class="shMessage from" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $message->sender_firstname.' '.$message->sender_lastname?></td>
                        <?php }?>
                        <td class="shMessage subject" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo $message->title;?></td>
                        <td class="shMessage attachment" <?php echo ($message->seen)?'style="color:#a5a5a5;"':'style="color:black;"'?>><div class="<?php echo $message->attachmentURL !='' ? 'uk-icon-paperclip' : '';?>"></div></td>
                        <td class="shMessage date" <?php echo ($message->seen)?'':'style="font-weight:bold;"'?>><?php echo DateTime::createFromFormat('Y-m-d H:i:s', $message->send_date)->format('d/m/Y - H:i');?></td>
                    </tr>
                    <?php endforeach;?>
                          </tbody>
       <?php
       }
       }

       else {
        ?>

        <p> No Messages </p>
  
        <?php
       }
        
      die();

      }
      

/*        $this->template->title = 'Outbox - Messages - The Ivy Key Portal';
        $this->template->content = View::factory('pannonia/Messages_view')
        ->set('users',$users)
        ->set('outbox_messages',$messages);    */



     /*   $this->template->title = 'Messages - The Ivy Key Portal';
        $this->template->header->page = 'Messages';
        $this->template->content = View::factory('front/messages', array('users' => $users, 'pagination' => $pagination));
        $this->template->content->messages = $messages;
        $this->template->content->box = 'outbox';
        $this->template->content->numberInbox = $this->checkInboxContent();
        $this->template->content->numberHomework = $this->checkHomeworkContent();*/
    }





   
     



}

 ?>   