<?php defined('SYSPATH') or die('No direct script access.');



class Controller_Front_ClassroomActions extends Controller_Front_Generic {

	private $userID;
	private $groupName;
	private $ProfPWD;
	private $StudPWD;

	public function __construct(Request $request, Response $response)
		{		
				if(!Auth::instance()->logged_in(array('student','tutor'))) die();
   				parent::__construct($request,$response);
   				$this->profesor = Auth::instance()->get_user()->first_name . '+' . Auth::instance()->get_user()->last_name;
   				$this->groupName = $this->request->post('groupName');
		}

	public function action_index(){

		$this->template->content = View::factory('admin');
	}

	
	public function action_createClassroom(){

		if(!Auth::instance()->logged_in('tutor')) die();

		$this->ProfPWD = $this->generateRandomString();
		$this->StudPWD = $this->generateRandomString();
		$name = str_replace(" ", "+", $this->groupName);
		$meetingID = $this->generateRandomString();

		

		require_once('includes/config.php');

		$chksum = $this->calculate_SHA1('createname='.$name.'&meetingID='.$meetingID.'&attendeePW='.$this->StudPWD.'&moderatorPW='.$this->ProfPWD.'&logoutURL=http://www.theivykey.com/ivykeyportal');

		$respondBBB = file_get_contents(CONFIG_SERVER_BASE_URL.'api/create?name='.$name.'&meetingID='.$meetingID.'&attendeePW='.$this->StudPWD.'&moderatorPW='.$this->ProfPWD.'&logoutURL=http://www.theivykey.com/ivykeyportal'.'&checksum='.$chksum);

		if (strpos($respondBBB,'SUCCESS') == false) {
    		echo 'Classroom is not created!'; die();
		}
		Model::factory('Classroom')->setClassroom($this->groupName, $meetingID, $this->ProfPWD, $this->StudPWD);
		
		$this->auto_render = false;
		

		$chksum = $this->calculate_SHA1('joinmeetingID='.$meetingID.'&password='.$this->ProfPWD.'&fullName='.$this->profesor);

		$link = CONFIG_SERVER_BASE_URL . 'api/join?meetingID='.$meetingID.'&password='.$this->ProfPWD.'&fullName='.$this->profesor.'&checksum='.$chksum;

		//$this->template->body->link = $link;
		$this->response->body(View::factory('pannonia/Classroom_Join_view')->set('link', $link));

	}

	public function action_joinClassroom(){

		
		if(!Auth::instance()->logged_in('student')) die();
		require_once('includes/config.php');
		$this->auto_render = false;
		$grp = $this->request->query('group');

		$joinId = Model::factory('Front_Classroom')->getClassroomIdAndPass($grp);
		$meetId = $joinId[0]['meeting_id'];
		$meetPw = $joinId[0]['student_pw'];

		$chksum = $this->calculate_SHA1('joinmeetingID='.$meetId.'&password='.$meetPw.'&fullName='.$this->profesor.'&logoutURL=http://www.theivykey.com/ivykeyportal');
		$link = CONFIG_SERVER_BASE_URL . 'api/join?meetingID='.$meetId.'&password='.$meetPw.'&fullName='.$this->profesor.'&logoutURL=http://www.theivykey.com/ivykeyportal'.'&checksum='.$chksum;



		$this->response->body(View::factory('pannonia/Classroom_Join_view')->set('link', $link));
	}

	protected function calculate_SHA1($string) {
		return sha1($string . CONFIG_SECURITY_SALT);
	}

	protected function generateRandomString($length = 10) {
    	$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    	$charactersLength = strlen($characters);
   		$randomString = '';
    	for ($i = 0; $i < $length; $i++) {
        	$randomString .= $characters[rand(0, $charactersLength - 1)];
    	}
    	return $randomString;
	}

	protected function populateDatabase($group, $meetingID, $profPW, $studPW){

	}




/*
		// Instatiate the BBB class:
$bbb = new BigBlueButton();

/* ___________ CREATE MEETING w/ OPTIONS ______ */
/* 
*/
/*
$creationParams = array(
	'meetingId' => '12342342', 					// REQUIRED
	'meetingName' => $this->groupName . ' classroom', 	// REQUIRED
	'attendeePw' => 'ap', 					// Match this value in getJoinMeetingURL() to join as attendee.
	'moderatorPw' => 'mp', 					// Match this value in getJoinMeetingURL() to join as moderator.
	'welcomeMsg' => '', 					// ''= use default. Change to customize.
	'dialNumber' => '', 					// The main number to call into. Optional.
	'voiceBridge' => '', 					// PIN to join voice. Optional.
	'webVoice' => '', 						// Alphanumeric to join voice. Optional.
	'logoutUrl' => '', 						// Default in bigbluebutton.properties. Optional.
	'maxParticipants' => '-1', 				// Optional. -1 = unlimitted. Not supported in BBB. [number]
	'record' => 'false', 					// New. 'true' will tell BBB to record the meeting.
	'duration' => '0', 						// Default = 0 which means no set duration in minutes. [number]
	//'meta_category' => '', 				// Use to pass additional info to BBB server. See API docs.
);

// Create the meeting and get back a response:
$itsAllGood = true;
try {$result = $bbb->createMeetingWithXmlResponseArray($creationParams);}
	catch (Exception $e) {
		echo 'Caught exception: ', $e->getMessage(), "\n";
		$itsAllGood = false;
	}

if ($itsAllGood == true) {
	// If it's all good, then we've interfaced with our BBB php api OK:
	if ($result == null) {
		// If we get a null response, then we're not getting any XML back from BBB.
		echo "Failed to get any response. Maybe we can't contact the BBB server.";
	}	
	else { 
	// We got an XML response, so let's see what it says:
	print_r($result);
		if ($result['returncode'] == 'SUCCESS') {
			// Then do stuff ...
			echo "<p>Meeting succesfullly created.</p>";
		}
		else {
			echo "<p>Meeting creation failed.</p>";
		}
	}
}*/
	

}
