<?php



defined('SYSPATH') or die('No direct script access.');



class Controller_Administration extends Controller_Generic {


  public function __construct(Request $request, Response $response){

   parent::__construct($request,$response);

    $user = Auth::instance()->get_user();

     if(!empty($user)) {

       if ( Auth::instance()->logged_in(array('tutor')) ){
         session_start();
         $_SESSION['user_type'] = 'tutor';
       }

       elseif ( Auth::instance()->logged_in(array('student'))) {
         header('Location: http://www.theivykey.com/');
         exit;

       }

       elseif ( Auth::instance()->logged_in(array('admin'))) {
         session_start();
         $_SESSION['user_type'] = 'admin';
        

       }

       else {
        echo 'this user is not tutor';
       }
   } else {
       header('Location: http://www.theivykey.com/');
       exit;
   }
   }


 
   public function action_index() {

        $this->template->title = "Administration";
        $this->template->content = View::factory('pannonia/Home_view');

    }





   public function action_Manage_Users() {

 if( $_SESSION['user_type'] == 'admin') {

    $user_model = Model::factory('user');
    $group_model = Model::factory('study');
    $count_users = $user_model->count_all_users();
    $all_locations = $group_model->list_all_locations();
    $first_name=null;
    $last_name=null;
    $search = null;
    $page = false;
    if(isset($_GET['page']))
    {
    $page  = $_GET['page'];
    $all_users =  $user_model->list_all_users($page,$search,$first_name,$last_name);
    }
  if(isset($_GET['position']))
   {
    $search = $_GET['position']; 
    $all_users =  $user_model->list_all_users($page,$search,$first_name,$last_name);
    }
  if(isset($_GET['first_name'])) {
    $first_name=$_GET['first_name'];
    $all_users =  $user_model->list_all_users($page,$search,$first_name,$last_name);
  }
  if(isset($_GET['last_name'])){
     $last_name=$_GET['last_name'];
     $all_users =  $user_model->list_all_users($page,$search,$first_name,$last_name);
  }
 
 


   if(!isset($_GET['page']) and !isset($_GET['position']))
   {
    $all_users =  $user_model->list_all_users($page,$search,$first_name,$last_name);
   }
    $all_groups = $group_model->list_all_groups();
   

     $this->template->content = View::factory('pannonia/Users_view')
   ->set('all_users', $all_users['result'])
   ->set('all_groups', $all_groups)
   ->set('all_locations',$all_locations)
   ->set('results_count', $all_users['count']);

  }


  else{

  	$this->template->content = View::factory('pannonia/Restricted_view');
  }

  
	$this->template->title = "Manage Users";




   }

  public function action_Manage_Groups() {


    $user_type = $_SESSION['user_type'];

    $group_model = Model::factory('study');
    $user_model = Model::factory('user');

    $all_courses = $group_model->list_all_courses();
    $all_locations = $group_model->list_all_locations();
    $all_students = $user_model->list_all_students();
    $all_schools = $user_model->list_all_schools();
    $all_tutors = $user_model->list_all_tutors();


    if( $user_type == 'admin' ) {

    $all_groups = $group_model->list_all_groups();
   
    
   

   $this->template->content = View::factory('pannonia/Groups_view')
   ->set('all_groups', $all_groups)
   ->set('all_courses', $all_courses)
   ->set('all_schools', $all_schools)
   ->set('all_tutors', $all_tutors)
   ->set('all_students', $all_students)
   ->set('all_locations', $all_locations);

   }


   if( $user_type == 'tutor' ) {


   
     $tutor_id =  Auth::instance()->get_user()->ID_user;
     $all_groups = $group_model->list_groups_by_tutor($tutor_id);

    $this->template->content = View::factory('pannonia/Groups_view')
    ->set('tutor_id',$tutor_id)
    ->set('all_groups', $all_groups)
    ->set('all_courses', $all_courses)
    ->set('all_schools', $all_schools)
    ->set('all_tutors', $all_tutors)
    ->set('all_students', $all_students)
    ->set('all_locations', $all_locations);




   }
	$this->template->title = "Manage Groups";

  }


  public function action_Manage_Courses() {

    $group_model = Model::factory('study');
    $all_courses = $group_model->list_all_courses();
    $this->template->content = View::factory('pannonia/Courses_view')
     ->set('all_courses', $all_courses);
 


  }




  public function action_Group_Details() {

  
  if(!empty($_GET['g'])) {

     $group_id = $_GET['g']; 
     $group_model = Model::factory('study');
     $user_model = Model::factory('user');

     $all_courses = $group_model->list_all_courses();
     $all_locations = $group_model->list_all_locations();
     $all_tutors = $user_model->list_all_tutors();
     $all_schools = $user_model->list_all_schools();
     $group_details = $group_model->get_single_group($group_id);
     $group_schedule = $group_model->get_group_schedule($group_id);
     $group_course = $group_model->get_group_course($group_id);
     $course_id = $group_course[0]['ID_course'];
     $group_tests = $group_model->get_group_course_tests($course_id,$group_id);
     $this->template->content = View::factory('pannonia/Group_Details_view')
     ->set('group_details', $group_details)
     ->set('group_schedule', $group_schedule)
     ->set('group_course',$group_course)
     ->set('group_tests',$group_tests)
     ->set('all_courses', $all_courses)
     ->set('all_schools', $all_schools)
     ->set('all_tutors', $all_tutors)
     ->set('all_locations', $all_locations);


     if(!empty($_GET['g']) and !empty($_GET['a'])) {
   
   //  $get_att =
     $schedule_id = $_GET['a'];
     $get_course_module = $group_model->get_single_schedule_module($schedule_id);


     
     $this->template->content = View::factory('pannonia/Group_Details_Att_view')
     ->set('group_details', $group_details)
     ->set('group_course',$group_course)
     ->set('course_module', $get_course_module)
     ->set('group_schedule', $group_schedule);


     }

   ///student in group details///

   if(!empty($_GET['s'])) {

     $student_id = $_GET['s']; 
     $student_details = $user_model->get_student_details($student_id,$group_id);
     $student_test_scores= $user_model->get_student_test_scores($student_id);
  
  
      $this->template->content = View::factory('pannonia/Group_Student_Details_view')
     ->set('student_details',$student_details)
     ->set('group_course',$group_course)
     ->set('student_test_scores',$student_test_scores);
      
   }



  }

}


function action_export_student_pdf() {

  require_once 'includes/tcpdf/tcpdf.php';


  if ( !empty($_GET['data']) ) {

  	$data = $_GET['data'];
  }



 $export_data = json_decode($data);


  // create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator('The IvyKey');
$pdf->SetAuthor('The IvyKey');
$pdf->SetTitle($export_data->first_name);
$pdf->SetSubject($export_data->first_name);
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data

/*$logo = '../../../../../../assets/images/ivylogo.png';

$pdf->SetHeaderData($logo, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
$pdf->setFooterData(array(0,64,0), array(0,64,128));*/

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set default font subsetting mode
$pdf->setFontSubsetting(true);

// Set font
// dejavusans is a UTF-8 Unicode font, if you only need to
// print standard ASCII chars, you can use core fonts like
// helvetica or times to reduce file size.
$pdf->SetFont('helvetica', '', 14, '', true);

// Add a page
// This method has several options, check the source code documentation for more information.
$pdf->AddPage();

// set text shadow effect
$pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.1, 'depth_h'=>0.1, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));



$student_image = '../assets/images/users/'.$export_data->student_image;

$pdf->Image($student_image, '', '', 40, 40, 'jpg', '', 'T', false, 300, '', false, false, 1, false, false, false);



$html  = '<p>First Name:'. $export_data->first_name .'</p>';
$html .=' <p>Last Name:'. $export_data->last_name.'</p>';
$html .=' <p>Classes attended:'. $export_data->total_attended.'</p>';
$html .=' <p>Classes missed:'. $export_data->total_missed.'</p>';
$html .=' <p>Total test score:'. $export_data->total_test_score.'</p>';

if( $export_data->total_missed > 0 ) {

$html .='<h3>Missed Classes </h3>';

foreach ( $export_data->missed as $missed ) {

  

  $html .= '<p>'.$missed.'</p>';

}


}










// Print text using writeHTMLCell()
$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output('example_001.pdf', 'I');

die();

//============================================================+
// END OF FILE
//============================================================+

}


function get_student_attendance($student_id,$schedule_id) {

  $user_model = Model::factory('user');

  return $user_model->get_student_attendance($student_id,$schedule_id);



}

 public function action_Course_Details() {


  if(!empty($_GET['c'])){

   $course_id = $_GET['c'];
   $group_model = Model::factory('study');
   $course_details = $group_model->get_single_course($course_id);
   $course_tests = $group_model->get_course_tests($course_id);
  

   $cnt = count($course_details);
   $i=0;

   for ($i;$i<$cnt;$i++) {

    if(!empty($course_details[$i]['module_id'])) {

   $course_details[$i]['class_units']  = $group_model->get_class_units($course_details[$i]['module_id']);
   $course_details[$i]['class_homework']  = $group_model->get_class_homework($course_details[$i]['module_id']);

   }
  }

  $this->template->content = View::factory('pannonia/Course_Details_view')
  ->set('course_details', $course_details) 
  ->set('course_tests', $course_tests);

  }



 }



  public function action_Get_Tutor() {
   $id = $this->request->param('id');

   echo $id;

  // $user_model = Model::factory('user');
  // $tutor_info = $user_model->get_tutor_info($id);
  }






















    public function action_groups() {

        $study_model = Model::factory('study');

        $groups = $study_model->list_all_groups();

        $locations = $study_model->list_all_locations();

        $courses = $study_model->list_all_courses();

        $tutors = $study_model->list_all_tutors();

        $this->template->content = View::factory('groups')

                ->set('groups', $groups)

                ->set('locations', $locations)

                ->set('courses', $courses)

                ->set('tutors', $tutors);

    }



    public function action_locations() {

        $study_model = Model::factory('study');

        $locations = $study_model->list_all_locations();

        $location_types = $study_model->list_all_location_types();

        $this->template->content = View::factory('locations')

                ->set('locations', $locations)

                ->set('location_types', $location_types);

    }



    public function action_create_location() {

        $study_model = Model::factory('study');

        $study_model->create_location();

        echo 'location created successfully<br/><a href="locations">Go back</a>';

        die();

    }



    public function action_edit_location() {

        $study_model = Model::factory('study');

        $study_model->edit_location();

        echo 'location edited successfully<br/><a href="locations">Go back</a>';

        die();

    }



    public function action_courses() {

        $this->template->content = View::factory('courses');

    }



    public function action_create_group() {

        $study_model = Model::factory('study');

        $study_model->create_group();

        echo 'group created successfully<br/><a href="groups">Go back</a>';

        die();

    }



    public function action_edit_group() {

        $study_model = Model::factory('study');

        $study_model->edit_group();

        echo 'group edited successfully<br/><a href="groups">Go back</a>';

        die();

    }



    public function action_insert_into_group() {

        

    }



    public function action_journal() {

        $ID_group_schedule = Request::current()->param('id');

        if ($ID_group_schedule > 0) {

            $user_model = Model::factory('user');

            $journal = $user_model->list_journal($ID_group_schedule);

            $this->template->content = View::factory('student_list')

                    ->set('journal', $journal);

        } else {

            print_r('No journal selected.');

            die();

        }

    }



    /////////////////////////////////////////////////////////////////



    public function action_review() {

        $test_model = Model::factory('user');

        $data = $test_model->student_course_review(2, 1);

        $this->template->content = View::factory('test_review')

                ->set('data', $data);

    }



    public function action_spreadsheet() {

        $test_model = Model::factory('user');

        $data = $test_model->spreadsheet_student(2, 1);

        $this->template->content = View::factory('test_spreadsheet_student')

                ->set('data', $data);

    }



    public function action_adminspreadsheet() {

        $test_model = Model::factory('user');

        $data = $test_model->spreadsheet_admin(1);

        $this->template->content = View::factory('test_spreadsheet_admin')

                ->set('data', $data);

    }



    public function action_find() {

        $this->template->content = View::factory('test_find_school');

    }



    public function action_find_school() {

        $test_model = Model::factory('user');

        $data = $test_model->find_school();

        $this->template->content = View::factory('test_find_school_results')

                ->set('data', $data);

    }



    public function action_find_tutor() {

        $this->template->content = View::factory('test_find_tutor');

    }



    public function action_find_tutor_results() {

        $test_model = Model::factory('user');

        $data = $test_model->find_tutor();

        if ($data[0]['first_name'] != 'not found') {

            $this->template->content = View::factory('test_find_tutor_results')

                    ->set('data', $data);

        } else {

            $this->template->content = View::factory('test_find_tutor');

        }

    }



    /////////////    cms    /////////////////////////

    /////////tutor////////



    public function action_tutor() {



        $test_model = Model::factory('user');

        $data[0] = $test_model->tutor_combo();



        $test_model = Model::factory('user');

        $data[1] = $test_model->select_tutor(1);

        $data[2] = null;

        $this->template->content = View::factory('test_select_tutor')

                ->set('data', $data);

    }



    public function action_add_tutor() {

        $this->template->content = View::factory('test_insert_tutor');

    }



    public function action_insert_tutor() {



        $test_model = Model::factory('user');

        $is = $test_model->insert_tutor();

        $test_model = Model::factory('user');

        $data[0] = $test_model->tutor_combo();



        $test_model = Model::factory('user');

        $data[1] = $test_model->select_tutor($is[0]['ID_user']);

        $data[2] = $is;



        $this->template->content = View::factory('test_select_tutor')

                ->set('data', $data);

    }



    public function action_update_tutor() {



        $test_model = Model::factory('user');

        $is = $test_model->update_tutor();

        $test_model = Model::factory('user');

        $data[0] = $test_model->tutor_combo();



        $test_model = Model::factory('user');

        $data[1] = $test_model->select_tutor($is[0]['ID_user']);

        $data[2] = $is;

        $this->redirect(View::factory('test_select_tutor')

                        ->set('data', $data));



//        $this->template->content = View::factory('test_select_tutor')

//                    ->set('data', $data);

    }



    /////////tutor////////


  public function action_Manage_Messages() {


      echo 'Inbox';
      $msgs = Request::factory('Messages/Inbox')->execute()->response;
      $this->template->content = View::factory('pannonia/Messages_view');

        

  }


 public function action_Send_schedule_update_email() {

  $group_id = $this->request->param('group');
  $new_date = $this->request->param('date');

  $group_model = Model::factory('study');
  $group_details = $group_model->get_group_students($group_id);


/*  $subject = 'Schedule Change';

  $headers = "From: " . 'admin@ivykey.com' . "\r\n";
  $headers .= "Reply-To: ". 'admin@ivykey.com' . "\r\n";
  $headers .= "Return-Path: admin2@ivykey.com\r\n";
  $headers .= "MIME-Version: 1.0\r\n";
  $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

  $message = '<html><body>';
  $message .= '<p>The schedule for class has been changed</p>';
  $message .= '</body></html>';


   */

  $message = wordwrap("TEST");

     
  foreach ($group_details as $gd) {

    $to  = $gd['parent_email'];

   // mail($to, $subject, $message, $headers); 

    $email = Email::factory('Schedule has changed', $message)
                   ->to($to)
                   ->from('admin@theivykey.com', 'IvyKey')
                   ->send();


    
  }




 }


}

