<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_News extends Controller_CmsTemplate {

    protected $news_image_url = '';
    
    public function action_index()
    {
        $news_data = ORM::factory('news')->find_all();

        $sort_order = array("id" => "asc");
        $this->template->title .= " - CMS News";
        $this->template->content = View::factory('cms/news_view');
        $this->template->content->news_data = $news_data;

    }

    public function action_addNews(){
        $news = ORM::factory('news');
        $this->template->title .= " - CMS Add News";
        $this->template->content = View::factory('cms/addNews_view');
        $this->template->content->image = $news;
    }

    public function action_sortToggle(){

    }
    
    public function _edit_news($filenm=''){

        $postin = $this->request->post();

        $news = ORM::factory('news')->where('ID_news_events','=',$postin['edit'])->find();
               

        $news->title = HTML::chars($postin['title']);
        $news->content = HTML::chars($postin['content']);
        if($filenm!=''){
        $news->image = HTML::chars($filenm);}

        $news->update();
        
   }

   public function _add_news($filenm=''){

        $postin = $this->request->post();

        $news = ORM::factory('news');
               

        $news->title = HTML::chars($postin['title']);
        $news->content = HTML::chars($postin['content']);
        if($filenm!=''){
        $news->image = HTML::chars($filenm);}

        $news->save();
        
   }



   public function action_editNews(){

        $news = ORM::factory('news')->where('ID_news_events','=',$this->request->param('id'))->find();
        $this->template->title .= " - Edit News";
        $this->template->content = View::factory('cms/editNews_view');
        $this->template->content->news = $news;
   }

   public function action_delete(){
        $news = ORM::factory('news')->where('ID_news_events','=',$this->request->param('id'))->find();
        $news->delete();
        HTTP::redirect("Cms/News/index");
          }

    public function action_upload()
    {

        $error_message = NULL;
        $filename = NULL;
        
        if ($this->request->method() == Request::POST)
        {
            if (isset($_FILES['image']))
            {
                $filename = $this->_save_image($_FILES['image']);
            }
        }
 
        //if ( ! $filename)
        //{
        //    $error_message = 'There was a problem while uploading the image.
        //        Make sure it is uploaded and must be JPG/PNG/GIF file.';
        //}
        //if(!empty($_FILES['photoTutor']['name']))   {
        //$this->_add_new_tutor($filename); } else {$this->_add_new_tutor();}

        $this->_edit_news($filename);

        HTTP::redirect("Cms/News/index");
    }

    public function action_uploadNews()
    {

        $error_message = NULL;
        $filename = NULL;
        
        if ($this->request->method() == Request::POST)
        {
            if (isset($_FILES['image']))
            {
                $filename = $this->_save_image($_FILES['image']);
            }
        }
 
        //if ( ! $filename)
        //{
        //    $error_message = 'There was a problem while uploading the image.
        //        Make sure it is uploaded and must be JPG/PNG/GIF file.';
        //}
        //if(!empty($_FILES['photoTutor']['name']))   {
        //$this->_add_new_tutor($filename); } else {$this->_add_new_tutor();}

        $this->_add_news($filename);

        HTTP::redirect("Cms/News/index");
    }

 
    protected function _save_image($image)
    {
        if (
            ! Upload::valid($image) OR
            ! Upload::not_empty($image) OR
            ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif')))
        {
            return FALSE;
        }
 
        $directory = DOCROOT.'assets/images/';
 
        if ($file = Upload::save($image, NULL, $directory))
        {

            $exten = explode(".", $image['name']);
            $ext = end($exten);

            $filename = strtolower(Text::random('alnum', 20)).'.'.$ext;
 
            Image::factory($file)
                ->resize(200, 200, Image::WIDTH)
                ->save($directory.$filename);
 
            // Delete the temporary file
            unlink($file);
 
            return $filename;
        }
 
        return FALSE;
    }

}