<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_Dashboard extends Controller_CmsTemplate {
    
    private $model;
    private $model_schools;
    
    public function action_index()
    {   
        $header_data = ORM::factory('home')->where('name', '=', 'logo_image')->find();
        $this->template->title .= " - CMS Dashboard";
        $this->template->content = View::factory('cms/dashboard_view');
        
        $this->model = new Model_users();
        $this->model_schools = new Model_dashboard();
        
        $numberOfUsers = count($this->model->list_all_users());
        $this->template->content->numberOfUsers = $numberOfUsers;
        
        $numberOfTutors = count($this->model->list_all_specific_users(2));
        $this->template->content->numberOfTutors = $numberOfTutors;
        
        $numberOfActiveTutors = count($this->model->list_all_active_users(2));
        $this->template->content->numberOfActiveTutors = $numberOfActiveTutors;
        
        $numberOfStudents = count($this->model->list_all_specific_users(4));
        $this->template->content->numberOfStudents = $numberOfStudents;
        
        $numberOfActiveStudents = count($this->model->list_all_active_users(4));
        $this->template->content->numberOfActiveStudents = $numberOfActiveStudents;
        
        $numberOfSchools = $this->model_schools->count_all_schools();
        $this->template->content->numberOfSchools = $numberOfSchools[0]['COUNT(*)'];
        
        $numberOfSchoolsK5 = $this->model_schools->count_all_schools_by_type(1);
        $this->template->content->numberOfSchoolsK5 = $numberOfSchoolsK5[0]['COUNT(*)'];
        $numberOfSchools68 = $this->model_schools->count_all_schools_by_type(2);
        $this->template->content->numberOfSchools68 = $numberOfSchools68[0]['COUNT(*)'];
        $numberOfSchoolsHS = $this->model_schools->count_all_schools_by_type(3);
        $this->template->content->numberOfSchoolsHS = $numberOfSchoolsHS[0]['COUNT(*)'];
        
        //echo '<pre>';        print_r($numberOfSchools); die();
    }

}