<?php
defined('SYSPATH') or die('No direct script access.');

class Controller_Aboutus extends Controller_IvyTemplate
{
    
    public function action_index() {
        $header_data = ORM::factory('home')->where('name', '=', 'logo_image')->find();
        $news = ORM::factory('news')->find_all();
        
        $this->template->title.= " - About Us";
        $this->template->content = View::factory('aboutus_view');
        $this->template->content->news = $news;
    }
    
    public function action_sendemail() {
        $this->template->title.= " - eMail confirmation";
        $this->template->content = View::factory('mail_confirm_view');
        include_once ('modules/recaptcha/g-recaptchalib.php');
        
        $resp = recaptcha_check_valid($_POST['g-recaptcha-response'], $_SERVER["REMOTE_ADDR"]);
        
        if (!$resp->is_valid) {
            $this->template->content->errors = $resp->error;
            
            //echo('<pre>'); var_dump($this->template->content); die();
            
            
        } 
        else {
            
            $post = Arr::map('trim', $this->request->post());
            $post = Validation::factory($post);
            $post->rule('email', 'email')->rule('email', 'not_empty')->rule('topic', 'min_length', array(':value', 2))->rule('topic', 'not_empty')->rule('question', 'min_length', array(':value', 6))->rule('question', 'not_empty')->rule('name', 'min_length', array(':value', 6))->rule('name', 'not_empty');
            
            if ($post->check()) {
                $name_of_sender = $this->request->post('name');
                $email = $this->request->post('email');
                $topic = $this->request->post('topic');
                $message_content = $this->request->post('question');
                $message_content = wordwrap("\nThe Ivy Key web contact form e-mail\n\n----------------------------------------------------\n\nName of sender: " . $name_of_sender . "\n\n" . "Topic: " . $topic . "\n\n----------------------------------------------------\n\n" . "Question: \n" . $message_content . "\n\n\n=======================================================\nSender IP: " . $_SERVER['REMOTE_ADDR'] . "\nE-mail generated by PHP Swiftmailer 5.1.0 - The Ivy Key", 70, "\n");
                
                $email = Email::factory('The Ivy Key web contact form', $message_content)->to('info@theivykey.com')->from($email, $name_of_sender)->send();
                if ($email) {
                    $this->template->content->confirmation = true;
                } 
                else {
                    $this->template->content->confirmation = false;
                }
            } 
            else {
                $this->template->content->errors = $post->errors();
                $this->template->content->confirmation = false;
            }
        }
    }
    
    public function action_sendrequest() {
        
        $this->template->title.= " - Request tutor confirmation";
        $this->template->content = View::factory('request_confirm_view');
        include_once ('modules/recaptcha/g-recaptchalib.php');
        
        $resp = recaptcha_check_valid($_POST['g-recaptcha-response'], $_SERVER["REMOTE_ADDR"]);
        
        if (!$resp->is_valid) {
            $this->template->content->errors = $resp->error;
            $this->template->content->confirmation = false;
            //echo('<pre>'); print_r($this->template->content->errors); die();
        } 
        else {
            $post = Arr::map('trim', $this->request->post());
            $post = Validation::factory($post);
            $post->rule('email', 'email')->rule('zip', 'exact_length', array(':value', 5))->rule('phone', 'phone')->rule('name', 'min_length', array(':value', 6));
            //echo('<pre>'); print_r($post->check()); die();
            if ($post->check()) {
                $name_of_sender = $this->request->post('name');
                $email = $this->request->post('email');
                $zip = $this->request->post('zip');
                $phone = $this->request->post('phone');
                $tutor = $this->request->post('tutor');
                $requester = $this->request->post('requester');
                $comments = $this->request->post('comments');
                
                $message_content = wordwrap("\nThe Ivy Key web tutor request form e-mail\n\nRequest for tutor: " . $tutor . "\n\n----------------------------------------------------\n\nName of sender: " . $name_of_sender . "\nRequester: " . $requester . "\n" . "Phone: " . $phone . "\nZip: " . $zip . "\n\n----------------------------------------------------\n\n" . "Additional comments: \n" . $comments . "\n\n\n=======================================================\nSender IP: " . $_SERVER['REMOTE_ADDR'] . "\nE-mail generated by PHP Swiftmailer 5.1.0 - The Ivy Key", 70, "\n");
                
                $email = Email::factory('The Ivy Key web contact form', $message_content)->to('info@theivykey.com')->from($email, $name_of_sender)->send();
                if ($email) {
                    $this->template->content->confirmation = true;
                } 
                else {
                    $this->template->content->confirmation = false;
                }
            } 
            else {
                $this->template->content->errors = $post->errors();
                $this->template->content->confirmation = false;
            }
        }
        
        //echo('<pre>'); var_dump($this->template->content); die();
        
        
    }
}
